
// ScienceCamp-2014View.cpp : implementation of the CScienceCamp2014View class
//

#include "stdafx.h"
// SHARED_HANDLERS can be defined in an ATL project implementing preview, thumbnail
// and search filter handlers and allows sharing of document code with that project.
#ifndef SHARED_HANDLERS
#include "ScienceCamp-2014.h"
#endif
#include "DlgUnlockCode.h"
#include "ScienceCamp-2014Doc.h"
#include "ScienceCamp-2014View.h"
#include "VigenereQuestionDlg.h"
#include "DlgModArith.h"
#include "DlgAutokey.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CScienceCamp2014View

IMPLEMENT_DYNCREATE(CScienceCamp2014View, CFormView)

BEGIN_MESSAGE_MAP(CScienceCamp2014View, CFormView)
	ON_BN_CLICKED(IDC_BTN_ENCRYPT, &CScienceCamp2014View::OnBnClickedBtnEncrypt)
	ON_BN_CLICKED(IDC_BTN_DECRYPT, &CScienceCamp2014View::OnBnClickedBtnDecrypt)
	ON_BN_CLICKED(IDC_BTN_ANALYZE, &CScienceCamp2014View::OnBnClickedBtnAnalyze)
	ON_COMMAND(ID_RESETLOCKS_RESETALLLOCKS, &CScienceCamp2014View::OnResetlocksResetalllocks)
	ON_BN_CLICKED(IDC_BTN_Manual, &CScienceCamp2014View::OnBnClickedBtnManual)
	ON_COMMAND(ID_FILE_MODULARARITHMETIC, &CScienceCamp2014View::OnFileModulararithmetic)
	ON_BN_CLICKED(IDC_BTN_AUTOKEY, &CScienceCamp2014View::OnBnClickedBtnAutokey)
END_MESSAGE_MAP()

// CScienceCamp2014View construction/destruction

CScienceCamp2014View::CScienceCamp2014View()
	: CFormView(CScienceCamp2014View::IDD)
{
	// TODO: add construction code here
	dlgPtr = NULL;
}

CScienceCamp2014View::~CScienceCamp2014View()
{
	//if (dlgPtr != NULL) delete dlgPtr;
}

void CScienceCamp2014View::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_RDO_NONE, mBtnNone);
//	DDX_Control(pDX, IDC_RDO_ANALYSISNONE, mBtnAnalyzeNone);
	DDX_Control(pDX, IDC_BTN_ENCRYPT, mBtnEncrypt);
	DDX_Control(pDX, IDC_BTN_DECRYPT, mBtnDecrypt);
	DDX_Control(pDX, IDC_BTN_ANALYZE, mBtnAnalyze);
	DDX_Control(pDX, IDC_TXT_PLAIN, mTxtPlain);
	DDX_Control(pDX, IDC_TXT_CYPHERTXT, mTxtCypher);
	DDX_Control(pDX, IDC_STC_KEYNAME, mLblKey);
	DDX_Control(pDX, IDC_LBL_CYPHER, mLblCypher);
	DDX_Control(pDX, IDC_TXT_KEY, mTxtKey);
	DDX_Control(pDX, IDC_CHK_PRESERVE, mChkPreserve);
	DDX_Control(pDX, IDC_TXT_ANALYSIS, mTxtAnalysis);
}

BOOL CScienceCamp2014View::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CScienceCamp2014View::OnInitialUpdate()
{
	this->ShowWindow(SW_SHOWMAXIMIZED);
	CFormView::OnInitialUpdate();
	ResizeParentToFit();

	this->mBtnNone.SetCheck(1);

	this->CaesarUnlocked = AfxGetApp()->GetProfileIntW(_T("Unlocked"), _T("Caesar"), 0);
	this->VigenereUnlocked = AfxGetApp()->GetProfileIntW(_T("Unlocked"), _T("Vigenere"), 0);
	this->SubstitutionUnlocked = AfxGetApp()->GetProfileIntW(_T("Unlocked"), _T("Substitution"), 0);
	this->ColumnarUnlocked = AfxGetApp()->GetProfileIntW(_T("Unlocked"), _T("Columnar"), 0);
	this->AutokeyUnlocked = AfxGetApp()->GetProfileIntW(_T("Unlocked"), _T("Autokey"), 0);

	
	
//	this->mBtnAnalyzeNone.SetCheck(1);

	//ResizeControls();
}


// CScienceCamp2014View diagnostics

#ifdef _DEBUG
void CScienceCamp2014View::AssertValid() const
{
	CFormView::AssertValid();
}

void CScienceCamp2014View::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CScienceCamp2014Doc* CScienceCamp2014View::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CScienceCamp2014Doc)));
	return (CScienceCamp2014Doc*)m_pDocument;
}
#endif //_DEBUG


// CScienceCamp2014View message handlers


void CScienceCamp2014View::OnBnClickedBtnEncrypt()
{
	CDlgUnlockCode *dlgPtr;
	int i = 0;

	if (((CButton *)GetDlgItem(IDC_RDO_CAESAR))->GetCheck() == true) {
		if (this->CaesarUnlocked == 0){
			dlgPtr = new CDlgUnlockCode;
			dlgPtr->codeStr = CString("Type the code the unlock the Caesar Shift cipher.");
			dlgPtr->DoModal();
			if ((dlgPtr->codeStr).MakeUpper() == CString("EXPERIENCEISTHETEACHEROFALLTHINGS")){ 
				CaesarUnlocked = -1; 
				AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Caesar"), -1);
				AfxMessageBox(_T("Caesar Shift unlocked!"));
			}
			else{ AfxMessageBox(_T("Incorrect code")); }
		}
		if (this->CaesarUnlocked != 0){ CaesarEncrypt(); } 
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_SUBSTITUTION))->GetCheck() == true) {
		if (this->SubstitutionUnlocked == 0){
			dlgPtr = new CDlgUnlockCode;
			dlgPtr->codeStr = CString("Type the code the unlock the Substitution cipher.");
			dlgPtr->DoModal();
			if ((dlgPtr->codeStr).MakeUpper() == CString("PSUCAMPIN")){ 
				SubstitutionUnlocked = -1;  
				AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Substitution"), -1); 
				AfxMessageBox(_T("Substitution unlocked!"));
			}
			else{ AfxMessageBox(_T("Incorrect code")); }
		}
		if (this->SubstitutionUnlocked != 0){ SubstitutionEncrypt(); }
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_VIGENERE))->GetCheck() == true) {
		if (this->VigenereUnlocked == 0){
			dlgPtr = new CDlgUnlockCode;
			dlgPtr->codeStr = CString("Type the code the unlock the Vigenere cipher.");
			dlgPtr->DoModal();
			if ((dlgPtr->codeStr).MakeUpper() == CString("XYZABCLMN")){ 
				VigenereUnlocked = -1; 
				AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Vigenere"), -1);
				AfxMessageBox(_T("Vigenere unlocked!"));
			}
			else{ AfxMessageBox(_T("Incorrect code")); }
		}
		if (this->VigenereUnlocked != 0){ VigenereEncrypt(); }
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_COLUMNTRANSPOSE))->GetCheck() == true) {
		if (this->ColumnarUnlocked == 0){
			dlgPtr = new CDlgUnlockCode;
			dlgPtr->codeStr = CString("Type the code the unlock the Columnar Transposition cipher.");
			dlgPtr->DoModal();
			if ((dlgPtr->codeStr).MakeUpper() == CString("EVERYDOGHASHISDAY")){ 
				ColumnarUnlocked = -1; 
				AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Columnar"), -1);
				AfxMessageBox(_T("Columnar Transposition unlocked!"));
			}
			else{ AfxMessageBox(_T("Incorrect code")); }
		}
		if (this->ColumnarUnlocked != 0){ ColumnarTransposeEncrypt(); }
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_AUTOKEY))->GetCheck() == true) {
		if (this->AutokeyUnlocked == 0){
			dlgPtr = new CDlgUnlockCode;
			dlgPtr->codeStr = CString("Type the code the unlock the Autokey cipher.");
			dlgPtr->DoModal();
			if ((dlgPtr->codeStr).MakeUpper() == CString("SYNDICATE")){ //green side of the rubiks
				AutokeyUnlocked = -1;
				AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Autokey"), -1);
				AfxMessageBox(_T("Autokey unlocked!"));
			}
			else{ AfxMessageBox(_T("Incorrect code")); }
		}
		if (this->AutokeyUnlocked != 0){ AutokeyEncrypt(); }
	}
}




void CScienceCamp2014View::OnBnClickedBtnDecrypt()
{
	
	if (((CButton *)GetDlgItem(IDC_RDO_CAESAR))->GetCheck() == true) {
		CaesarDecrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_SUBSTITUTION))->GetCheck() == true) {
		SubstitutionDecrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_VIGENERE))->GetCheck() == true) {
		VigenereDecrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_COLUMNTRANSPOSE))->GetCheck() == true) {
		ColumnarTransposeDecrypt();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_AUTOKEY))->GetCheck() == true) {
		AutokeyDecrypt();
	}
}

void CScienceCamp2014View::OnBnClickedBtnAnalyze()
{
	// TODO: Add your control notification handler code here
	//ResizeControls();

	if (((CButton *)GetDlgItem(IDC_RDO_ANALYZEFREQUENCY))->GetCheck() == true) {
		FrequencyAnalysis();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_AUTOCORROLATION))->GetCheck() == true) {
		this->Autocorrelation();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_ANALYZEFREQUENCYVIGENERE))->GetCheck() == true) {
		this->VigenereAnalysis();
	}
	else if (((CButton *)GetDlgItem(IDC_RDO_DIGRAPHS))->GetCheck() == true) {
		this->DigraphAnalysis();
	}
}


//*****************
/*Encrypt button*/
//*****************
void CScienceCamp2014View::VigenereEncrypt()
{
	int i, j, k, len, keyLen;
	CString myString, keyString;
	this->mTxtPlain.GetWindowText(myString);
	len = myString.GetLength();

	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	keyLen = keyString.GetLength();
	wchar_t *key = (wchar_t *)keyString.GetBuffer();
	wchar_t *plain = (wchar_t *)myString.GetBuffer();
	wchar_t *crypt = new wchar_t[2*len + 1];

	if (this->mChkPreserve.GetCheck() == true) {
		j = 0;
		for (i = 0; i < len; i++)
		{
			if ((plain[i] >= 'A') && (plain[i] <= 'Z')){
				crypt[i] = ((plain[i] - 'A') + (key[j%keyLen]-'A')) % 26 + 'A';
				j++;
			}
			else if ((plain[i] >= 'a') && (plain[i] <= 'z')){
				crypt[i] = ((plain[i] - 'a') + (key[j%keyLen]-'A')) % 26 + 'a';
				j++;
			}
			else{
				crypt[i] = plain[i];
			}
		}
		crypt[len] = 0;
	}
	else{
		j = 0;
		k = 0;
		for (i = 0; i < len; i++)
		{
			if (plain[i] >= 'A' && plain[i] <= 'Z'){
				crypt[j] = 'A' + (plain[i] - 'A' + key[k%keyLen]-'A') % 26;
				j++; k++;
			}
			else if (plain[i] >= 'a' && plain[i] <= 'z'){
				crypt[j] = 'A' + (plain[i] - 'a' + key[k%keyLen] - 'A') % 26;
				j++; k++;
			}
			if (j % 5 == 4){ crypt[j] = ' '; j++; }
		}
		crypt[j] = 0;

	}
	
	mTxtCypher.SetWindowTextW(crypt);
	delete[] crypt;
}


void CScienceCamp2014View::CaesarEncrypt()
{
	// TODO: Add your control notification handler code here
	int i, j, len;
	CEdit* txtPlain = (CEdit *)GetDlgItem(IDC_TXT_PLAIN);
	CEdit* txtKey = (CEdit *)GetDlgItem(IDC_TXT_KEY);
	CEdit* txtCrypt = (CEdit *)GetDlgItem(IDC_TXT_CYPHERTXT);

	CString myString;
	txtPlain->GetWindowText(myString);
	wchar_t *s = (wchar_t *)myString.GetBuffer();
	len = myString.GetLength();
	wchar_t *crypt = new wchar_t[2*len + 1];

	CString myNum;
	txtKey->GetWindowText(myNum);
	int caesarShift = _wtoi(myNum);

	if (this->mChkPreserve.GetCheck() == true) {
		for (i = 0; i < len; i++){
			if (s[i] >= 'A' && s[i] <= 'Z'){
				crypt[i] = 'A' + (s[i] - 'A' + caesarShift) % 26;
			}
			else if (s[i] >= 'a' && s[i] <= 'z'){
				crypt[i] = 'a' + (s[i] - 'a' + caesarShift) % 26;
			}
			else { crypt[i] = s[i]; }
		}
		crypt[len] = 0;
	}
	else{
		j = 0;
		for (i = 0; i < len; i++){
			if (s[i] >= 'A' && s[i] <= 'Z'){
				crypt[j] = 'A' + (s[i] - 'A' + caesarShift) % 26;
				j++;
			}
			else if (s[i] >= 'a' && s[i] <= 'z'){
				crypt[j] = 'A' + (s[i] - 'a' + caesarShift) % 26;
				j++;
			}
			if (j % 5 == 4){ crypt[j] = ' '; j++; }
		}
		crypt[j] = 0;
	}

	txtCrypt->SetWindowTextW(crypt);
	delete[] crypt;
}

void CScienceCamp2014View::SubstitutionEncrypt()
{
	int i, j, len;

	CString plainString,keyString;
	mTxtPlain.GetWindowText(plainString);
	wchar_t *s = (wchar_t *)plainString.GetBuffer();
	len = plainString.GetLength();
	wchar_t *crypt = new wchar_t[2 * len + 1];
	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	//keyString = keyString.SpanIncluding(_T("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
	wchar_t *key = (wchar_t *) keyString.GetBuffer();

	if (keyString.GetLength() < 26){
		CString errorStr("Error, expected a key with 26 letters for a substitution cypher.");
		AfxMessageBox(errorStr, MB_OK, 0);
	}
	else{
		if (this->mChkPreserve.GetCheck() == true) {
			for (i = 0; i < len; i++){
				if (s[i] >= 'A' && s[i] <= 'Z'){
					crypt[i] = key[s[i]-'A'];
				}
				else if (s[i] >= 'a' && s[i] <= 'z'){
					crypt[i] = key[s[i] - 'a'];
				}
				else { crypt[i] = s[i]; }
			}
			crypt[len] = 0;
		}
		else{
			j = 0;
			for (i = 0; i < len; i++){
				if (s[i] >= 'A' && s[i] <= 'Z'){
					crypt[j] = key[s[i] - 'A'];
					j++;
				}
				else if (s[i] >= 'a' && s[i] <= 'z'){
					crypt[j] = key[s[i] - 'a'];
					j++;
				}
				if (j % 5 == 4){ crypt[j] = ' '; j++; }
			}
			crypt[j] = 0;
		}
		mTxtCypher.SetWindowTextW(crypt);
	}
	
	
	delete[] crypt;


}

void CScienceCamp2014View::ColumnarTransposeEncrypt()
{
	CString plainString, keyString;
	mTxtPlain.GetWindowText(plainString);
	mTxtKey.GetWindowText(keyString);

	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);

	if (mChkPreserve.GetCheck() == false){
		plainString.MakeUpper();
		plainString = this->KeepLettersOnly(plainString);
	}

	wchar_t *s = (wchar_t *)plainString.GetBuffer();
	wchar_t *key = (wchar_t *)keyString.GetBuffer();
	int slen = wcslen((const wchar_t *)s);
	int len = wcslen ((const wchar_t *) key);
	int *realKey = new int[2*len+1];
	int *realKey2 = new int[2 * len + 1];
	int i, j, count;
	for (i = 0; i < len; i++){
		count = 0;
		for (j = 0; j < len; j++){
			if ((key[i] > key[j]) || ((key[i] == key[j]) && (i > j))) { count++;  }
		}
		realKey[i] = count;
	}
	count = 0;
	//realKey lists the order the columns should be read in
	for (i = 0; i < len; i++){
		realKey2[realKey[i]] = i;
	}

	int colSize = (slen + len - 1) / len;  //do slen/len but round up
	wchar_t *plainText = new wchar_t[colSize*len + 1];
	wchar_t *cipherText = new wchar_t[colSize*len + 1];
	for (i = 0; i < colSize*len; i++){    //initialize the array
		if (i < slen){
			plainText[i] = s[i];
		}
		else{
			plainText[i] = rand() % 26 + 'A';
		}
	}
	plainText[i] = 0;
	//fill in the array

	//now do the encryption
	for (i = 0; i < colSize*len; i++){
		cipherText[i] = plainText[(i*len)%(colSize*len) + realKey2[i/colSize]];
	}
	cipherText[i] = 0;

	mTxtCypher.SetWindowTextW(cipherText);
	delete[] plainText;
	delete[] cipherText;
	delete[] realKey;
	delete[] realKey2;
}

void CScienceCamp2014View::AutokeyEncrypt()
{
	int i, j, k, len, keyLen;
	CString myString, keyString;
	this->mTxtPlain.GetWindowText(myString);
	myString = this->KeepLettersOnly(myString);
	len = myString.GetLength();

	mTxtKey.GetWindowText(keyString);
	keyString = keyString + myString;
	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	keyLen = keyString.GetLength();
	wchar_t *key = (wchar_t *)keyString.GetBuffer();
	wchar_t *plain = (wchar_t *)myString.GetBuffer();
	wchar_t *crypt = new wchar_t[2 * len + 1];

	if (this->mChkPreserve.GetCheck() == true) {
		AfxMessageBox(_T("Autokey currently does not support preservation of punctuation."));
	}
	else{
		j = 0;
		k = 0;
		for (i = 0; i < len; i++)
		{
			if (plain[i] >= 'A' && plain[i] <= 'Z'){
				crypt[j] = 'A' + (plain[i] - 'A' + key[k%keyLen] - 'A') % 26;
				j++; k++;
			}
			else if (plain[i] >= 'a' && plain[i] <= 'z'){
				crypt[j] = 'A' + (plain[i] - 'a' + key[k%keyLen] - 'A') % 26;
				j++; k++;
			}
			if (j % 5 == 4){ crypt[j] = ' '; j++; }
		}
		crypt[j] = 0;

	}

	mTxtCypher.SetWindowTextW(crypt);
	myString = KeepLettersOnly(CString(crypt));
	i = myString.GetLength();
	delete[] crypt;
}


//*****************
/*Decrypt button*/
//*****************

void CScienceCamp2014View::VigenereDecrypt()
{
	int i, j, k, len, keyLen;
	CString myString, keyString;
	this->mTxtCypher.GetWindowText(myString);
	len = myString.GetLength();

	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	keyLen = keyString.GetLength();
	wchar_t *key = (wchar_t *)keyString.GetBuffer();
	wchar_t *crypt = (wchar_t *)myString.GetBuffer();
	wchar_t *plain = new wchar_t[2*len + 1];

	if (this->mChkPreserve.GetCheck() == true) {
		j = 0;
		for (i = 0; i < len; i++)
		{
			if ((crypt[i] >= 'A') && (crypt[i] <= 'Z')){
				plain[i] = ((crypt[i] - 'A') - (key[j%keyLen] - 'A')+26) % 26 + 'A';
				j++;
			}
			else if ((crypt[i] >= 'a') && (crypt[i] <= 'z')){
				plain[i] = ((crypt[i] - 'a') - (key[j%keyLen] - 'A')+26) % 26 + 'a';
				j++;
			}
			else{
				plain[i] = crypt[i];
			}
		}
		plain[len] = 0;
	}
	else{
		j = 0;
		k = 0;
		for (i = 0; i < len; i++)
		{
			if (crypt[i] >= 'A' && crypt[i] <= 'Z'){
				plain[j] = 'A' + (crypt[i] - 'A' - (key[k%keyLen] - 'A')+26) % 26;
				j++; k++;
			}
			else if (crypt[i] >= 'a' && crypt[i] <= 'z'){
				plain[j] = 'A' + (crypt[i] - 'a' - (key[k%keyLen] - 'A')+26) % 26;
				j++; k++;
			}
			if (j % 5 == 4){ plain[j] = ' '; j++; }
		}
		plain[j] = 0;

	}

	mTxtPlain.SetWindowTextW(plain);
	delete[] plain;
}

void CScienceCamp2014View::CaesarDecrypt()
{
	int i, len;
	CEdit* txtPlain = (CEdit *)GetDlgItem(IDC_TXT_PLAIN);
	CEdit* txtKey = (CEdit *)GetDlgItem(IDC_TXT_KEY);
	CEdit* txtCrypt = (CEdit *)GetDlgItem(IDC_TXT_CYPHERTXT);

	CString myString;
	txtCrypt->GetWindowText(myString);
	wchar_t *s = (wchar_t *)myString.GetBuffer();
	len = myString.GetLength();
	wchar_t *plain = new wchar_t[len + 1];

	CString myNum;
	txtKey->GetWindowText(myNum);
	int caesarShift = _wtoi(myNum);

	for (i = 0; i < len; i++){
		if (s[i] >= 'A' && s[i] <= 'Z'){
			plain[i] = 'A' + (s[i] - 'A' - caesarShift+26) % 26;
		}
		else if (s[i] >= 'a' && s[i] <= 'z'){
			plain[i] = 'a' + (s[i] - 'a' - caesarShift+26) % 26;
		}
		else { plain[i] = s[i]; }
	}
	plain[len] = 0;

	txtPlain->SetWindowTextW(plain);
	delete[] plain;
}


void CScienceCamp2014View::SubstitutionDecrypt()
{
	int i, j, len, val,err=false;

	CString cryptString, keyString;
	mTxtCypher.GetWindowText(cryptString);
	wchar_t *s = (wchar_t *)cryptString.GetBuffer();
	len = cryptString.GetLength();
	wchar_t *plain = new wchar_t[len + 1];
	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	if (keyString.GetLength() > 26) {
		keyString.Truncate(26);
	}
	else if (keyString.GetLength() < 26){
		CString errorStr("Key length too short");
		AfxMessageBox(errorStr, MB_OK, 0);
	}
	if (keyString.GetLength() == 26){
		wchar_t *dualKey = new wchar_t[27];
		for (i = 0; i < 26; i++){
			val = keyString.Find('A' + i, 0);
			if (val > -1){
				dualKey[i] = 'A' + val;
			}
			else{
				dualKey[i] = '?'; err = true;
			}
		}
		dualKey[26] = 0;
		if (err == true){
			CString errorStr("Some letters did not have inverses");
			AfxMessageBox(errorStr, MB_OK, 0);
		}
		else{
			j = 0;
			for (i = 0; i < len; i++){
				if (s[i] >= 'A' && s[i] <= 'Z'){
					plain[j] = dualKey[s[i] - 'A'];
					j++;
				}
				else if (s[i] >= 'a' && s[i] <= 'z'){
					plain[j] = dualKey[s[i] - 'a'];
					j++;
				}
			}
			plain[j] = 0;

			mTxtPlain.SetWindowTextW(plain);
		}
	}
	delete[] plain;
}

void CScienceCamp2014View::ColumnarTransposeDecrypt()
{
	CString cypherString, keyString;
	mTxtCypher.GetWindowText(cypherString);
	mTxtKey.GetWindowText(keyString);

	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	
	if (this->mChkPreserve.GetCheck() != true) { cypherString = KeepLettersOnly(cypherString); }

	wchar_t *s = (wchar_t *)cypherString.GetBuffer();
	wchar_t *key = (wchar_t *)keyString.GetBuffer();
	int slen = wcslen((const wchar_t *)s);
	int len = wcslen((const wchar_t *)key);
	int *realKey = new int[2*len + 1];
	int *realKey2 = new int[2 * len + 1];
	int i, j, count;
	for (i = 0; i < len; i++){
		count = 0;
		for (j = 0; j < len; j++){
			if ((key[i] > key[j]) || ((key[i] == key[j]) && (i > j))) { count++; }
		}
		realKey[i] = count;
	}
	count = 0;
	//realKey lists the order the columns should be read in
	for (i = 0; i < len; i++){
		realKey2[realKey[i]] = i;
	}




	int colSize = (slen + len - 1) / len;  //do slen/len but round up
	wchar_t *plainText = new wchar_t[colSize*len + 1];
	wchar_t *cipherText = new wchar_t[colSize*len + 1];
	for (i = 0; i < colSize*len; i++){    //initialize the array
		if (i < slen){
			cipherText[i] = s[i];
		}
		else{
			cipherText[i] = ' ';
		}
	}
	cipherText[i] = 0;
	//fill in the array
	for (i = 0; i < colSize*len; i++){
		plainText[(i*len) % (colSize*len) + realKey2[i / colSize]] = cipherText[i];
	}
	plainText[i] = 0;

	mTxtPlain.SetWindowTextW(plainText);
	delete[] plainText;
	delete[] cipherText;
	delete[] realKey;
}

void CScienceCamp2014View::AutokeyDecrypt()
{
	int i, j, k, b, len, keyLen;
	CString myString, keyString;
	this->mTxtCypher.GetWindowText(myString);
	myString = myString.MakeUpper();
	myString = this->KeepLettersOnly(myString);
	len = myString.GetLength();

	mTxtKey.GetWindowText(keyString);
	keyString = keyString.MakeUpper();
	keyString = this->KeepLettersOnly(keyString);
	keyLen = keyString.GetLength();
	wchar_t *key = new wchar_t[keyLen + 1];
	wcscpy_s(key, keyLen+1, (wchar_t *)keyString.GetBuffer());
	wchar_t *crypt = (wchar_t *)myString.GetBuffer();
	wchar_t *plain = new wchar_t[2 * len + 1];
	wchar_t *rawPlain = new wchar_t[2 * len + 1];

	if (this->mChkPreserve.GetCheck() == true) {
		AfxMessageBox(_T("Autokey currently does not support preservation of punctuation."));
	}
	else{
		j = 0;
		k = 0;
		for (i = 0; i < len; i++)
		{
			if (crypt[i] >= 'A' && crypt[i] <= 'Z'){
				plain[j] = 'A' + (crypt[i] - 'A' - (key[k%keyLen] - 'A') + 26) % 26;
				rawPlain[k] = 'A' + (crypt[i] - 'A' - (key[k%keyLen] - 'A') + 26) % 26;
				j++; k++;
			}
			else if (crypt[i] >= 'a' && crypt[i] <= 'z'){
				plain[j] = 'A' + (crypt[i] - 'a' - (key[k%keyLen] - 'A') + 26) % 26;
				rawPlain[k] = 'A' + (crypt[i] - 'a' - (key[k%keyLen] - 'A') + 26) % 26;
				j++; k++;
			}
			if (j % 5 == 4){ plain[j] = ' '; j++; }
			if (((i + 1) % keyLen) == 0) { //we periodically have to adjust the key
				for (b = 0; b < keyLen; b++){
					if (i + 1 - keyLen + b < myString.GetLength()){
						key[b] = rawPlain[i + 1 - keyLen + b];
					}
					else {
						key[b] = 0;
					}
				}
				b = 0;
			}
		}
		plain[j] = 0;

	}

	mTxtPlain.SetWindowTextW(plain);
	delete[] key;
	delete[] plain;
	delete[] rawPlain;
}


//*****************
/*Analyze*/
//*****************

void CScienceCamp2014View::FrequencyAnalysis(){
	CString cryptString;
	mTxtCypher.GetWindowText(cryptString);

	cryptString = cryptString.MakeUpper();
	cryptString = this->KeepLettersOnly(cryptString);

	wchar_t *s = (wchar_t *)cryptString.GetBuffer();
	int slen = wcslen((const wchar_t *)s);
	int charList[26];

	int i;

	for (i = 0; i < 26; i++){
		charList[i] = 0;
	}

	for (i = 0; i < slen; i++){
		charList[s[i] - 'A']++;
	}

	CString outString;
	CString tempStr;
	for (i = 0; i < 26; i++){
		tempStr.Format(_T("%c: %d\r\n"), 'A' + i, charList[i]);
		outString = outString + tempStr;
	}

	this->mTxtAnalysis.SetWindowTextW(outString);
}

struct Digraph{
	int num;
	wchar_t s[3];
};

int DigraphCompare(const void *a1, const void *a2){
	Digraph *b1 = (Digraph *)a1;
	Digraph *b2 = (Digraph *)a2;
	return (b2->num) - (b1->num);
}

void CScienceCamp2014View::DigraphAnalysis(){
	CString cryptString;
	mTxtCypher.GetWindowText(cryptString);

	cryptString = cryptString.MakeUpper();
	cryptString = this->KeepLettersOnly(cryptString);

	wchar_t *s = (wchar_t *)cryptString.GetBuffer();
	int slen = wcslen((const wchar_t *)s);
	int digraphList[26*26];
	int count = 0;

	int i, val;

	for (i = 0; i < 26*26; i++){
		digraphList[i] = 0;
	}

	for (i = 0; i < slen-1; i++){
		val = (s[i] - 'A') * 26 + (s[i + 1] - 'A');
		digraphList[val]++;
		if (digraphList[val] == 1){
			count++;
		}
	}

	Digraph *digraphs = new Digraph[count + 1];
	count = 0;
	for (i = 0; i < 26 * 26; i++){
		if (digraphList[i] > 0){
			digraphs[count].num = digraphList[i];
			digraphs[count].s[0] = 'A' + (i / 26);
			digraphs[count].s[1] = 'A' + (i % 26);
			digraphs[count].s[2] = 0;
			count++;
		}
	}

	qsort(digraphs, count, sizeof(Digraph), DigraphCompare);

	CString outString;
	CString tempStr;
	for (i = 0; i < count; i++){
		//if (digraphList[i] > 0){
		//tempStr.Format(_T("%c%c: %d\r\n"), 'A' + (i/26), 'A'+(i%26), digraphList[i]);
		tempStr.Format(_T("%s: %d\r\n"), digraphs[i].s, digraphs[i].num);
		outString = outString + tempStr;
		//}
	}

	this->mTxtAnalysis.SetWindowTextW(outString);
	delete[] digraphs;
}


void CScienceCamp2014View::VigenereAnalysis(){
	CVigenereQuestionDlg *qstDlg = new CVigenereQuestionDlg;
	int i, j;
	CString cryptString;
	mTxtCypher.GetWindowText(cryptString);

	cryptString = cryptString.MakeUpper();
	cryptString = this->KeepLettersOnly(cryptString);

	qstDlg->DoModal();

	wchar_t *s = (wchar_t *)cryptString.GetBuffer();
	int slen = wcslen((const wchar_t *)s);
	int **charList = new int*[qstDlg->finalNumber];

	for (j = 0; j< qstDlg->finalNumber; j++){
		charList[j] = new int[26];
		for (i = 0; i < 26; i++){
			charList[j][i] = 0;
		}
	}

	if (qstDlg->finalNumber > 0){
		for (i = 0; i < slen; i++){
			(charList[i % (qstDlg->finalNumber)][s[i] - 'A'])++;
		}
	}
	//format and display the results
	CString outString;
	CString tempStr;
	for (i = 0; i < 26; i++){
		for (j = 0; j < qstDlg->finalNumber; j++){
			tempStr.Format(_T("%c: %d\t"), 'A' + i, charList[j][i]);
			outString = outString + tempStr;
		}
		outString = outString + CString("\r\n");
	}
	this->mTxtAnalysis.SetWindowTextW(outString);

	//cleanup cleanup
	for (j = 0; j< qstDlg->finalNumber; j++){
		delete[] charList[j];
	}
	delete[] charList;

	delete qstDlg;
}

void CScienceCamp2014View::Autocorrelation(void){
	int i;
	CString tempStr, outStr, initString, shiftedString;

	mTxtCypher.GetWindowText(initString);
	initString = initString.MakeUpper();
	initString.Remove(' ');

	int len = initString.GetLength();

	int *correlations = new int[len];
	for (i = 1; i < len; i++){
		shiftedString = ShiftString(i, initString);
		correlations[i] = CorrelationCount(initString, shiftedString);
	}

	outStr = CString("shift: correlation\r\n");
	for (i = 1; i < len; i++){
		tempStr.Format(_T("%d: %d\r\n"), i, correlations[i]);
		outStr = outStr + tempStr;
	}

	this->mTxtAnalysis.SetWindowTextW(outStr);
	delete[] correlations;

}

//*****************
/*Other*/
//*****************

CString CScienceCamp2014View::KeepLettersOnly(CString tempStr){
	wchar_t *s1 = (wchar_t *)tempStr.GetBuffer();
	int len = tempStr.GetLength();
	int i, count = 0;
	wchar_t *s2 = new wchar_t[len + 1];
	CString outStr;

	for (i = 0; i < len; i++){
		if (((s1[i] <= 'Z') && (s1[i] >= 'A')) || ((s1[i] <= 'z') && (s1[i] >= 'a'))){
			s2[count] = s1[i];
			count++;
		}
	}
	s2[count] = 0;
	outStr = CString(s2);
	delete []s2;
	return outStr;
}

void CScienceCamp2014View::ResizeControls()
{
	CRect tempRect;
	this->GetWindowRect(&tempRect);
	int ht = tempRect.bottom - tempRect.top;
	int wdth = tempRect.right - tempRect.left;

	tempRect.left = wdth * 2 / 5;
	this->mTxtPlain.SetWindowPos(NULL, 0, 165, wdth * 2 / 5, ht - 165, 0);

	int i = 0;

}


CString CScienceCamp2014View::ShiftString(int shift, CString tempStr)
{
	CString firstStr, lastStr;
	firstStr = tempStr.Mid(0, shift);
	lastStr = tempStr.Mid(shift);

	return (lastStr + firstStr);
}


int CScienceCamp2014View::CorrelationCount(CString str1, CString str2){
	wchar_t *s1 = (wchar_t *)str1.GetBuffer();
	wchar_t *s2 = (wchar_t *)str2.GetBuffer();
	int i, len = min(str1.GetLength(), str2.GetLength()); 
	int count = 0;

	for (i = 0; i < len; i++){
		if (s1[i] == s2[i]) count++;
	}

	return count;
}

void CScienceCamp2014View::OnResetlocksResetalllocks()
{
	// TODO: Add your command handler code here
	this->CaesarUnlocked = false;
	this->VigenereUnlocked = false;
	this->SubstitutionUnlocked = false;
	this->ColumnarUnlocked = false;
	AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Vigenere"), 0);
	AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Caesar"), 0);
	AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Substitution"), 0);
	AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Columnar"), 0);
	AfxGetApp()->WriteProfileInt(_T("Unlocked"), _T("Autokey"), 0);

}


void CScienceCamp2014View::OnBnClickedBtnManual()
{
	// TODO: Add your control notification handler code here
	if (dlgPtr == NULL){
		dlgPtr = new CDlgManual(AfxGetMainWnd());
		this->mTxtCypher.GetWindowText(dlgPtr->myStr);
		dlgPtr->Create(CDlgManual::IDD);
		//dlgPtr->DoModal();
		
	}
	dlgPtr->ShowWindow(SW_SHOW);
}


void CScienceCamp2014View::OnFileModulararithmetic()
{
	// TODO: Add your command handler code here
	CDlgModArith *myDlg = new CDlgModArith;
	myDlg->DoModal();
	delete myDlg;
}


void CScienceCamp2014View::OnBnClickedBtnAutokey()
{
	// TODO: Add your control notification handler code here
	CDlgAutokey *myDlg = new CDlgAutokey;
	AfxInitRichEdit2();
	this->mTxtCypher.GetWindowText(myDlg->myStr);
	myDlg->myStr = KeepLettersOnly(myDlg->myStr);
	myDlg->myStr.MakeUpper();
	myDlg->DoModal();
	delete myDlg;
}
